//------------------------------------------------------------------------------
// File: svr_tasksystem.cs
// This file is used for initializing any task related systems and tasks on the
// server
// Author: Matthew Rudge
//------------------------------------------------------------------------------

//-Globals----------------------------------------------------------------------
$TaskHelperObjList = 0;
//------------------------------------------------------------------------------

//-Functions--------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Builds initial tasks (function may need to be removed later)
////////////////////////////////////////////////////////////////////////////////
function tsBuildInitialTasks()
{
   TaskBuilder.buildTaskList("building_experience");
   TaskBuilder.buildTaskList("GeneralTasks");
   TaskBuilder.buildTaskList("task_Badges");
   TaskBuilder.buildTaskList("task_BadgesGeneral");
   TaskBuilder.buildTaskList("task_Happiness");
   TaskBuilder.buildTaskList("task_Herostats");
   TaskBuilder.buildTaskList("task_Tombstone");
   TaskBuilder.buildTaskList("TutorialTasks");
   TaskBuilder.buildTaskList("StartTasks");
   TaskBuilder.buildTaskList("generalstore");
   TaskBuilder.buildTaskList("task_Mainmap");
   TaskBuilder.buildTaskList("outposttasks");
   TaskBuilder.buildTaskList("task_RescueSat");
   TaskBuilder.buildTaskList("firetutorial");
   TaskBuilder.buildTaskList("bridgetutorial");
   TaskBuilder.buildTaskList("SandboxTasks");
   TaskBuilder.buildTaskList("bridgedefense");
   TaskBuilder.buildTaskList("badseed");
   TaskBuilder.buildTaskList("townhalldefense");
   TaskBuilder.buildTaskList("deadmine");
   TaskBuilder.buildTaskList("escort");
   TaskBuilder.buildTaskList("snakevalley");
   TaskBuilder.buildTaskList("spypuzzle");
   TaskBuilder.buildTaskList("outpostgold");
   TaskBuilder.buildTaskList("outpostwood");
   TaskBuilder.buildTaskList("outpostfood");
   TaskBuilder.buildTaskList("famine");
   TaskBuilder.buildTaskList("madrussian");
   TaskBuilder.buildTaskList("whitewong");
   TaskBuilder.buildTaskList("task_Campaign2");
   TaskBuilder.buildTaskList("foodbaker");
   TaskBuilder.buildTaskList("Tasks_Global");
   TaskBuilder.buildTaskList("finalshowdown");
   TaskBuilder.buildTaskList("task_TornadoValley");
   TaskBuilder.buildTaskList("tasks_AnimalTrap");
}

////////////////////////////////////////////////////////////////////////////////
//! Initializes and starts the task system on the server
////////////////////////////////////////////////////////////////////////////////
function tsBuildServerTaskSystem()
{
   // Build the task manager
   slgBuildTaskManager(true);
}

////////////////////////////////////////////////////////////////////////////////
//! Initializes one-time elements of the task system
////////////////////////////////////////////////////////////////////////////////
function tsInitializeTaskSystem()
{
   tsLoadTaskStrings("stringtable/taskstrings");
   slgBuildTaskBuilder();
   tsCreateBadges();
}

////////////////////////////////////////////////////////////////////////////////
//! Destroys the task system and all its components on the server
////////////////////////////////////////////////////////////////////////////////
function tsDestroyServerTaskSystem()
{
   // Destroy helper object list
   if(isObject($TaskHelperObjList)) {
      $TaskHelperObjList.delete();
   }
   $TaskHelperObjList = 0;

   // Shut down the task manager
   slgShutdownTaskManager();
}

////////////////////////////////////////////////////////////////////////////////
//! Used to recreate server task data upon scenario loads and game restarts
////////////////////////////////////////////////////////////////////////////////
function tsRecreateServerTaskData()
{
   if(isObject($TaskHelperObjList)) {
      $TaskHelperObjList.delete();
      $TaskHelperObjList = 0;
   }
   
   // Create helper object list
   $TaskHelperObjList = new SLGameObjList();
}

////////////////////////////////////////////////////////////////////////////////
//! starts the initial tutorial tasks (tutorial preparation, experience, etc.)
////////////////////////////////////////////////////////////////////////////////
function tsStartTutorialTasks()
{
   // initialize building experience for all buildings the first time they are built
   slgActivateTask("BuildingExperience", true);
   TaskModifier.strMarkVertex("BuildingExperience", "StartVertex", $TSV_CMPLETE);
   
   //Tutorial Tasks 
   slgActivateTask("TutorialTasks");
   TaskModifier.strMarkVertex("TutorialTasks", "TutorialStart", $TSV_AVAIL);
   
   // initialize the world map images
   tutorialworldmap.visible = true;
   campaign1worldmap.visible = false;
   campaign2worldmap.visible = false;
   fullworldmap.visible = false;
   
   // intialize the campaign icons
   tutorialworldicon.visible = false;
   campaign1worldicon.visible = false;
   campaign2worldicon.visible = false;
   
   // initialize the satellite icons
   SetTutorialSatellites(true);
   SetCampaign1Satellites(false);
   SetCampaign2Satellites(false);
   SetMadRussianSatellites(false);
}

////////////////////////////////////////////////////////////////////////////////
//! starts the initial game tasks (experience, etc.)
////////////////////////////////////////////////////////////////////////////////
function tsStartGameTasks()
{
   // initialize building experience for all buildings the first time they are built
   slgActivateTask("BuildingExperience", true);
   TaskModifier.strMarkVertex("BuildingExperience", "StartVertex", $TSV_CMPLETE);
   
	//Global Tasks 
   slgActivateTask("GlobalTasks", true);
   TaskModifier.strMarkVertex("GlobalTasks", "GlobalStartTasks", $TSV_AVAIL);
	
	//General Tasks 
   slgActivateTask("GeneralTasks");
   TaskModifier.strMarkVertex("GeneralTasks", "GeneralStart", $TSV_AVAIL);
	
	//Badges
   slgActivateTask("Badgetasks", true);
   TaskModifier.strMarkVertex("Badgetasks", "BadgeStart", $TSV_AVAIL);

   //Badges (General)
   slgActivateTask("Badgetasksgeneral");
   TaskModifier.strMarkVertex("Badgetasksgeneral", "BadgeStartGeneral", $TSV_AVAIL);   
   
   //Happiness Tasks
   slgActivateTask("Happinesstasks");
   TaskModifier.strMarkVertex("Happinesstasks", "HappinessTaskCounter", $TSV_AVAIL);
   
   //Tombstone 
   slgActivateTask("TombstoneTask");
   TaskModifier.strMarkVertex("TombstoneTask", "Tombstone_cemetery", $TSV_AVAIL);
   
   //General Store Bake Sale
   slgActivateTask("GeneralStore");
   TaskModifier.strMarkVertex("GeneralStore", "GeneralStoreInit", $TSV_AVAIL);
 
   //Starting Tasks, currently activated by Scenario Load.
   slgActivateTask("StartTasks");
   TaskModifier.strMarkVertex("StartTasks", "StartStart", $TSV_AVAIL);
   
   //Mainmap map Tasks
   slgActivateTask("MainmapTasks");
   TaskModifier.strMarkVertex("MainmapTasks", "Tutorialskip", $TSV_AVAIL);
   
   // initialize the world map images
   tutorialworldmap.visible = false;
   campaign1worldmap.visible = true;
   campaign2worldmap.visible = false;
   fullworldmap.visible = false;
   
   // intialize the campaign icons
   tutorialworldicon.visible = true;
   campaign1worldicon.visible = false;
   campaign2worldicon.visible = false;
   
   // initialize the satellite icons
   SetTutorialSatellites(true);
   SetCampaign1Satellites(true);
   SetCampaign2Satellites(false);
   SetMadRussianSatellites(false);
}

////////////////////////////////////////////////////////////////////////////////
//! starts the initial sandbox tasks and purchases all experience options
////////////////////////////////////////////////////////////////////////////////
function tsStartSandboxTasks()
{
   // disable the general store secrets
   tsEnableCommand(woolCmdData, false);
   tsEnableCommand(HoneyjarCmdData, false);
   tsEnableCommand(PumpkinpieCmdData, false);
   
   //Badges
   slgActivateTask("Badgetasks", true);
   TaskModifier.strMarkVertex("Badgetasks", "BadgeStart", $TSV_AVAIL);
   
   //Badges (General)
   slgActivateTask("Badgetasksgeneral");
   TaskModifier.strMarkVertex("Badgetasksgeneral", "BadgeStartGeneral", $TSV_AVAIL);
   
   //Happiness Tasks
   slgActivateTask("Happinesstasks");
   TaskModifier.strMarkVertex("Happinesstasks", "HappinessTaskCounter", $TSV_AVAIL);
   
   //Tombstone 
   slgActivateTask("TombstoneTask");
   TaskModifier.strMarkVertex("TombstoneTask", "Tombstone_cemetery", $TSV_AVAIL);
   
   //General Store Bake Sale
   slgActivateTask("GeneralStore");
   TaskModifier.strMarkVertex("GeneralStore", "GeneralStoreInit", $TSV_AVAIL);
   
   // Sandbox Tasks
   slgActivateTask("SandboxTasks");
   TaskModifier.strMarkVertex("SandboxTasks", "SandboxStart", $TSV_AVAIL);
   
   // outpost tasks
   slgActivateTask("OutpostTasks", true);
   TaskModifier.strMarkVertex("OutpostTasks", "OutpostTaskInit", $TSV_AVAIL);
   
   //Global Tasks 
   slgActivateTask("GlobalTasks");
   TaskModifier.strMarkVertex("GlobalTasks", "GlobalStartTasks", $TSV_AVAIL);

}

////////////////////////////////////////////////////////////////////////////////
//! Returns the starting vertexes for a task
//! \param %task Name of task
//! \retval string of vertex names to start as available
////////////////////////////////////////////////////////////////////////////////
function tsGetStartingVertexes(%task)
{
   switch$(%task) {
         // MainmapTask Vertexes
      case "MainmapTasks":
         return ("PlatformTriggerZone" SPC 
                 "HopeRefugeesIntro" SPC 
                 "LoadCombat" SPC 
                 "FireTutorialTrigger" SPC
                 "BridgeTutorialTrigger" SPC
                 "FoodLowTrigger");
      
         // Fire Tutorial Vertexes
      case "FireTutorial":
         return ("FireInit");
         
         // Bridge Tutorial Vertexes
      case "BridgeTutorial":
         return ("BridgeTutorialInit");
      
         // Bridge Defense Vertexes
      case "BridgeDefense":
         return ("BridgeDefenseIntro" SPC "BridgeDefenseLose");
         
         // Bad Seed Vertexes
      case "BadSeed":
         return ("BadSeedIntro");
         
         // Town Hall Defense Vertexes
      case "TownHallDefense":
         return ("TownHallDefenseIntro");
      
      
      /*** DEAD MINE TASKS ***/
         // Dead Mine Vertexes
      case "DeadMine":
         return ("DeadMineIntro" SPC
                 "DeadMineCaveWallZone" SPC
                 "DeadMineTombZone" SPC
                 "DeadMineFindTreasure" SPC
                 "DeadMineLose");
         // Dynamite Vertexes
      case "Dynamite":
         return ("DynamiteStoreZone");
         // Horse Rescue Vertexes
      case "HorseRescue":
         return ("HorseRescueHorseFound");
      
      
      /*** SNAKE VALLEY TASKS ***/
         // Core Snake Valley Vertexes
      case "SnakeValley":
         return ("SnakeValleyIntro" SPC
                 "SnakeValleyLose");
                 
      /*** FAMINE TASKS ***/
      case "FamineTask":
         return ("FamineIntro");
         
      /*** MAD RUSSIAN CAPTURE TASKS ***/
      case "MadRussianCapture":
         return ("MRCIntro");
         
      /*** WHITE OR WONG TASKS ***/
      case "WhiteWongTask":
         return ("WhiteWongTownZone" SPC
                 "WhiteWongLose" SPC
                 "WhiteWongBanditZone" SPC
                 "WhiteWongPit");
                 
       /*** FOOD BAKER TASKS ***/
       case "FoodBakerTask":
         return ("FoodBakerZone");
         
      /*** FINAL SHOWDOWN TASKS ***/
      case "FinalShowdown":
         return ("FinalShowdownIntro" SPC
                 "GateOneZoneNoKey" SPC
                 "GateTwoZoneNoKey");
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Notifies server that a client is ready for tutorial tasks to be started
//! \param %client Client that is read for initial tasks
////////////////////////////////////////////////////////////////////////////////
function serverCmdStartTutorialTasks(%client)
{
   tsRecreateServerTaskData();

   // Start initial tasks
   tsStartTutorialTasks();
}

////////////////////////////////////////////////////////////////////////////////
//! Notifies server that a client is ready for game tasks to be started
//! \param %client Client that is read for initial tasks
////////////////////////////////////////////////////////////////////////////////
function serverCmdStartGameTasks(%client)
{
   tsRecreateServerTaskData();

   // Start initial tasks
   tsStartGameTasks();
}

////////////////////////////////////////////////////////////////////////////////
//! Notifies server that a client is ready for sandbox tasks to be started
//! \param %client Client that is read for initial tasks
////////////////////////////////////////////////////////////////////////////////
function serverCmdStartSandboxTasks(%client)
{
   tsRecreateServerTaskData();

   // Start initial tasks
   tsStartSandboxTasks();
}
//------------------------------------------------------------------------------

// this turns the tutorial satellite icons on/off
function SetTutorialSatellites(%on)
{
   // there are no tutorial satellites, but there are secret
   // satellites that should always be turned off when the
   // tutorial satellites are turned off
   
   // visibility flags
   mapsatellite_animaltrap.visible = false;
   mapsatellite_outpostfood.visible = false;
   mapsatellite_outpostwood.visible = false;
   mapsatellite_outpostgold.visible = false;
   
   // disable all satellites
   mapsatellite_animaltrap.disabled = true;
   mapsatellite_outpostfood.disabled = true;
   mapsatellite_outpostwood.disabled = true;
   mapsatellite_outpostgold.disabled = true;
}

// this turns the campaign 1 satellite icons on/off
function SetCampaign1Satellites(%on)
{
   // visibility flags
   mapsatellite_deadmine.visible = %on;
   mapsatellite_badseed.visible = %on;
   mapsatellite_hoperescue.visible = %on;
   mapsatellite_bridgedefense.visible = %on;
   mapsatellite_spy.visible = %on;
   mapsatellite_escort.visible = %on;
   mapsatellite_famine.visible = %on;
   
   // disable all satellites
   mapsatellite_deadmine.disabled = true;
   mapsatellite_badseed.disabled = true;
   mapsatellite_hoperescue.disabled = true;
   mapsatellite_bridgedefense.disabled = true;
   mapsatellite_spy.disabled = true;
   mapsatellite_escort.disabled = true;
   mapsatellite_famine.disabled = true;
}

// this turns the campaign 2 satellite icons on/off
function SetCampaign2Satellites(%on)
{
   // visibility flags
   mapsatellite_townhall.visible = %on;
   mapsatellite_bakeoff.visible = %on;
   mapsatellite_snakevalley.visible = %on;
   mapsatellite_tornadovalley.visible = %on;
   mapsatellite_whiteorwong.visible = %on;
   mapsatellite_madrussian.visible = %on;
   
   // disable all satellites
   mapsatellite_townhall.disabled = true;
   mapsatellite_bakeoff.disabled = true;
   mapsatellite_snakevalley.disabled = true;
   mapsatellite_tornadovalley.disabled = true;
   mapsatellite_whiteorwong.disabled = true;
   mapsatellite_madrussian.disabled = true;
}

// this turns the mad russian satellite icons on/off
function SetMadRussianSatellites(%on)
{
   // disable all satellites
   mapsatellite_finalwong.disabled = true;
   mapsatellite_finalwhite.disabled = true;
   
   // if the satellites should be turned off
   if (%on == false)
   {
      mapsatellite_finalwong.visible = false;
      mapsatellite_finalwhite.visible = false;
      return;
   }
   
   // determine which satellite should be made visible based on
   // if white or wong is chosen
   if (WhiteWongChooseWhite.hasBeenCompleted() == true)
   {
      mapsatellite_finalwhite.visible = true;
   }
   else if (WhiteWongChooseWong.hasBeenCompleted() == true)
   {
      mapsatellite_finalwong.visible = true;
   }
}

// End svr_tasksystem.cs
